<?php

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class WLT_List_Table extends WP_List_Table{
    public function prepare_items(){
        $order_by = isset( $_GET['orderby'] ) ? $_GET['orderby'] : '';
        $order = isset( $_GET['order'] ) ? $_GET['order'] : '';
        $searh_form = isset( $_POST['s'] ) ? $_POST['s'] : '';

        $this->items = $this->wp_list_table_data( $order_by, $order, $searh_form);

        $wp_column = $this -> get_columns();
        $wp_hd_column = $this -> get_hidden_columns();
        $sortable = $this -> get_sortable_columns();

        $this->_column_headers = [ $wp_column, $wp_hd_column, $sortable];
    }

    public function wp_list_table_data($order_by = '', $order = '', $searh_form = ''){
        ?>
            <section>
        <?php
        global $wpdb;
        $table_name = $wpdb->prefix . "Inovi_FormDetails";
        if(!empty($searh_form)){
            $results = $wpdb->get_results( "SELECT * FROM $table_name WHERE TransactionID LIKE '%$searh_form%'");
        }else{
            if($order_by=="TransactionID"){

            }
            else{

                $results = $wpdb->get_results( "SELECT * FROM $table_name");
            }
        }
        $data_array = [];
        if ($results){
            foreach($results as $record){
                $data_array[] = [
                    'wp_id' => $record->ID,
                    'wp_TransactionID' => $record->TransactionID,
                    'wp_Fname' =>  $record->Fname,
                    'wp_Lname' =>  $record->Lname,
                    'wp_Address' =>  $record->Address,
                    'wp_City' =>  $record->City,
                    'wp_State' =>  $record->State,
                    'wp_Postal' =>  $record->Postal,
                    'wp_Country' =>  $record->Country,
                    'wp_Phone' =>  $record->Phone,
                    'wp_Cell' =>  $record->Cell,
                    'wp_Email' =>  $record->Email,
                    'wp_Solicited' =>  $record->Solicited,
                    'wp_donation' =>  $record->donation,
                    'wp_Donation_Des' =>  $record->Donation_Des,
                    'wp_Comments' =>  $record->Comments
                ];
            }
        }
        ?>
            </section>
        <?php
        return $data_array;
    }

    public function get_hidden_columns(){
        return [];
    }

    public function get_columns(){
        $column = [
            'cb'    => '<input type="checkbox"/>',
            'wp_id' => __('ID', Plug_TEXT_DOMAIN),
            'wp_TransactionID' => __('TransactionID', Plug_TEXT_DOMAIN),
            'wp_Fname' => __('First name', Plug_TEXT_DOMAIN),
            'wp_Lname' => __('Last name', Plug_TEXT_DOMAIN),
            'wp_Address' => __('Address', Plug_TEXT_DOMAIN),
            'wp_City' => __('City', Plug_TEXT_DOMAIN),
            'wp_State' => __('State', Plug_TEXT_DOMAIN),
            'wp_Postal' => __('Postal', Plug_TEXT_DOMAIN),
            'wp_Country' => __('Country', Plug_TEXT_DOMAIN),
            'wp_Phone' => __('Phone', Plug_TEXT_DOMAIN),
            'wp_Cell' => __('Cell', Plug_TEXT_DOMAIN),
            'wp_Email' => __('Email', Plug_TEXT_DOMAIN),
            'wp_Solicited' => __('Solicited', Plug_TEXT_DOMAIN),
            'wp_donation' => __('donation', Plug_TEXT_DOMAIN),
            'wp_Donation_Des' => __('Donation Desc', Plug_TEXT_DOMAIN),
            'wp_Comments' => __('Comments', Plug_TEXT_DOMAIN)
        ];
        return $column;
    }

    public function column_default( $item, $column_name ){
        switch ( $column_name ){
            case 'wp_id' :
            case 'wp_TransactionID' :
            case 'wp_Fname' :
            case 'wp_Lname' :
            case 'wp_Address' :
            case 'wp_City' :
            case 'wp_State' :
            case 'wp_Postal' :
            case 'wp_Country' :
            case 'wp_Phone' :
            case 'wp_Cell' :
            case 'wp_Email' :
            case 'wp_Solicited' :
            case 'wp_donation' :
            case 'wp_Donation_Des' :
            case 'wp_Comments' :
                return $item[$column_name];
            default :
                return ' ';
        }
    }

    public function column_cb( $item ){
        $checkbox = '<input type="checkbox"/>';
        return $checkbox;
    }
}

$object = new WLT_List_Table();
$object->prepare_items();
$object->display();

?>