<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php
   /*
   Plugin Name: Custom Form
   description: a plugin to create forms and payments.
   Version: 1.2
   Author: <a href="mailto:syedtalha@gmail.com">Syed Talha</a>
   License: GPL2
   */

   function get_available_token(){
    return 3;  
   }

   function admin_dash(){

   }

   function get_stripe_details(){
      global $wpdb;
      $table_name = $wpdb->prefix . "customized_stripe_details";
      $results = $wpdb->get_results( "SELECT * FROM $table_name WHERE IsActive = 1");
      return $results[0];
   }
   
   function form_body(){
      $token = get_available_token();
      renderbody($token);
   }

   function sending_email($to, $message){
      // if the submit button is clicked, send the email
      if(isset( $_POST['inovi-submitted'] )){
         $subject = "Ticket Purchased by: ".$_POST['Innovi-Fname'];
         $headers = array('Content-Type: text/html; charset=UTF-8');
         //Here put your Validation and send mail
         $sent = wp_mail($to, $subject, $message,$headers);
         if($sent) {
            //message sent!    
            return 1;   
         }
         else  {
            //message wasn't sent   
            return false;    
         }
      }
   }

   function form_posting(){
      // if the submit button is clicked, send the email
      if(isset( $_POST['inovi-submitted'] ) ){
         // sanitize form values
         $ticket = sanitize_text_field( get_available_token() );
         $first = sanitize_text_field( $_POST['first'] );
         $last  = sanitize_text_field( $_POST['last'] );
         $company = sanitize_text_field( $_POST['company'] );
         $address  = sanitize_text_field( $_POST['address'] );
         $city  = sanitize_text_field( $_POST['city'] );
         $state  = sanitize_text_field( $_POST['state'] );
         $postal  = sanitize_text_field( $_POST['postal'] );
         $country  = sanitize_text_field( $_POST['country'] );
         $phone = sanitize_text_field( $_POST['phone'] );
         $cell = sanitize_text_field( $_POST['cell'] );
         $email  = sanitize_text_field( $_POST['email'] );
         $card  = sanitize_text_field( $_POST['i_card'] );
         $month = sanitize_text_field( $_POST['i_month'] );
         $year  = sanitize_text_field( $_POST['i_year'] );
         $cvv  = sanitize_text_field( $_POST['i_cvv'] );
         $solicited  = sanitize_text_field( $_POST['solicited '] );
         $donation = sanitize_text_field( $_POST['donation'] );
         $donation_comments = sanitize_text_field( $_POST['donation_comments'] );
         $additional_comments = sanitize_text_field( $_POST['additional_comments'] );
         //echo "<script>alert('card=".$card.length()."; year=".$year."; month=".$month."');</script>";

         $IsPaid = payment_detection($first, $card, $month, $year, $cvv);
         if(!$IsPaid){
            echo".";
            echo'<script type="text/JavaScript">Swal.fire("The site is under development!", "Admin need to update STRIPE Security Key", "error");</script>';
         }
         if($IsPaid->status == "succeeded"){
            $IsUpdated = record_insertion($IsPaid->payment_method, $ticket, $first, $last, $company, $address, $city, $state, $postal, $country, $phone, $cell, $email, $card, $month, $year, $cvv, $solicited, $donation, $donation_comments, $additional_comments);
            if($IsUpdated == 1){
               $IsSent = sending_email($email,$client_msg);
               $IsSent = sending_email($email,$admin_msg);
               if($IsSent == 1){
                  echo ".";
                  //Success message
                  echo '<script type="text/JavaScript">Swal.fire("Great","We have received your request, you will be hear back from us soon.","success");</script>';
               }else{
                  echo ".";
                  //Success message
                  echo '<script type="text/JavaScript">Swal.fire("Great","We have received your request, you will be hear back from us soon.","success");</script>';

               }
            }else{
               echo "Card has been charged however we've not logged your info in our CMS.<br>";
               echo "Kindly note down your Transaction #".$IsPaid->payment_method;
            }
         }
         if($IsPaid->status != "succeeded"){
            if(str_contains($IsPaid, "Your ") || str_contains($IsPaid, "Your ")){
               echo".";
               echo'<script type="text/JavaScript">Swal.fire("Error!", "'.$IsPaid.'", "error");</script>';
            }
         }
      }
      
   }

   function stripe_token($SecretKey, $card, $month, $year, $cvv){
      // if the submit button is clicked, send the email
      if(isset( $_POST['inovi-submitted'] ) ){

         //check if the values are null
         $card = empty($card) ? 0 : $card;
         $cvv = empty($cvv) ? 0 : $cvv;
         $year = empty($year) ? 0 : $year;
         $month = empty($month) ? 0 : $month;


         //data which will be posted in Stripe API in order to fetch Token for payment! 
         $Data = array('card[number]'=> $card,'card[exp_month]'=> $month,'card[exp_year]'=> $year,'card[cvc]'=> $cvv);
         $url = "https://api.stripe.com/v1/tokens";
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
         curl_setopt($ch, CURLOPT_URL, $url);
         curl_setopt($ch, CURLOPT_FRESH_CONNECT, TRUE);
         curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($Data));
         curl_setopt($ch, CURLOPT_POST, TRUE);
         curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer sk_test_51M6yjKL6zKSeaNf6OP6HHySIuavSVW05dT1sXAOn1P8q5GyjWgtfKcTyKUxfzpLGloXZyObwBT0UsGzmVwY2tP7n00XkD2tGnx','content-type: application/x-www-form-urlencoded',));
         curl_error($ch);
         
         //result received from Stripe API
         $response = curl_exec($ch);
         //converting into JSON
         $tokenid = json_decode($response);
         //checking if the response contains token or error!
         if($tokenid->id == ''){
             return $tokenid->error->message;
         }else{
             return $tokenid->id;
         }
     }
   }

   function payment_detection($first, $card, $month, $year, $cvv){
      // if the submit button is clicked, send the email
      if(isset( $_POST['inovi-submitted'] ) ){
         //Get Secret Key
         $stripe = get_stripe_details();
         if(empty($stripe->SecretKey)){
            return false;
         }
         $token = stripe_token($stripe->SecretKey, $card, $month, $year, $cvv);
         if(str_contains($token, "Your ")){
            return $token;
         }
         else{
            Stripe::setApiKey($stripe->SecretKey);
            $description 	= "Invoice #".rand(99999,999999999). " against ".$first;
            $amount_cents 	= (rand(10,360))*100;
            try{
                $Request = array('amount'=>$amount_cents,'currency'=>"usd",'description'=>$description,'source'=>$token);
                $url = "https://api.stripe.com/v1/charges";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_FRESH_CONNECT, TRUE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($Request));
                curl_setopt($ch, CURLOPT_POST, TRUE);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer '.$stripe->SecretKey,'content-type: application/x-www-form-urlencoded',));
                curl_error($ch);
                
                $TransactionID   = $charge['payment_method'];
                $currency 	      = $charge['currency'];
                $status 	      = $charge['status'];
                
                //executing Payment API in order to charge against the Token ID we received earlier.
                $response = curl_exec($ch);
                //converting values into JSON
                $IsPaid = json_decode($response);
                return $IsPaid;
            }
            catch(Stripe_CardError $e) {			
               $error = $e->getMessage();
               $result = "declined";
               return $result;
           }
         }
      }
   }

   function record_insertion($IsPaid, $ticket, $first, $last, $company, $address, $city, $state, $postal, $country, $phone, $cell, $email, $card, $month, $year, $cvv, $solicited, $donation, $donation_comments, $additional_comments){
      // if the submit button is clicked, send the email
      if(isset( $_POST['inovi-submitted'] ) ){
         global $wpdb;
         $table_name = $wpdb->prefix . "customized_form_plug";
         $my_products_db_version = '1.0.0';
         $charset_collate = $wpdb->get_charset_collate();
         $sql = "INSERT INTO `wp_customized_form_plug` 
         (`ID`, `Ticket`, `TransactionID`, `Fname`, `Lname`, `Company`, `Address`, `City`, `State`, `Postal`, `Country`, `Phone`, `Cell`, `Email`, `Solicited`, `Donation`, `donation_comments`, `Additional_comments`, `IsActive`) VALUES 
         (NULL, '$ticket', '$IsPaid', '$first', '$last', '$company', '$address', '$city', '$state', '$postal', '$country', '$phone', '$cell', '$email', '$solicited', '$donation', '$donation_comments', '$additional_comments', '1');";
         require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
         dbDelta($sql);
         add_option('my_db_version', $my_products_db_version);
         return 1;
      }
   }

   function plugin_relates(){
      global $wpdb;
      $table_name = $wpdb->prefix . "customized_form_plug";
      $my_products_db_version = '1.0.0';
      $charset_collate = $wpdb->get_charset_collate();

      //Table for Clients Data
      $sql = "CREATE TABLE $table_name (
         ID mediumint(9) NOT NULL AUTO_INCREMENT,
         `Ticket` TEXT NOT NULL,
         `TransactionID` TEXT NOT NULL,
         `Fname` TEXT NOT NULL,
         `Lname` TEXT NULL,
         `Company` TEXT NULL,
         `Address` TEXT NULL,
         `City` TEXT NULL,
         `State` TEXT NULL,
         `Postal` TEXT NULL,
         `Country` TEXT NULL,
         `Phone` TEXT NULL,
         `Cell` TEXT NULL,
         `Email` TEXT NULL,
         `Solicited` TEXT NULL,
         `Donation` TEXT NULL,
         `donation_comments` TEXT NULL,
         `Additional_comments` TEXT NULL,
         `IsActive` INT DEFAULT 1,
         PRIMARY KEY  (ID)
      ) $charset_collate;";
      require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
      dbDelta($sql);
      add_option('my_db_version', $my_products_db_version);

      //Table for STRIP
      $table_name = $wpdb->prefix . "customized_stripe_details";
      $sql = "CREATE TABLE $table_name (
         ID mediumint(9) NOT NULL AUTO_INCREMENT,
         `PublishableKey` TEXT NULL,
         `SecretKey` TEXT NULL,
         `IsActive` INT DEFAULT 1,
         PRIMARY KEY  (ID)
      ) $charset_collate;";
      require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
      dbDelta($sql);
      add_option('my_db_version', $my_products_db_version);

      //Inserting Dummy data
      $sql = "INSERT INTO $table_name (PublishableKey, SecretKey, IsActive) VALUES ('pk_test_51M6yjKL6zKSeaNf6DLsVj7VNP0DzR9hSgrcb0AoV9lcPowx6KYBVm5bCadckRHMQP8CXGBwQn9VM8TaWuJJaeOgv00TV79UwT6','sk_test_51M6yjKL6zKSeaNf6OP6HHySIuavSVW05dT1sXAOn1P8q5GyjWgtfKcTyKUxfzpLGloXZyObwBT0UsGzmVwY2tP7n00XkD2tGnx',1)";
      require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
      dbDelta($sql);
      add_option('my_db_version', $my_products_db_version);
   }

   require  __DIR__. '/admin.php';

   function render(){
      ob_start();
      form_posting();
      form_body();
      sending_email('','');
      return ob_get_clean();
   }

   require  __DIR__. '/stripe/Stripe.php';
   require  __DIR__. '/includes/templates/form.php';
   register_activation_hook( __FILE__, 'plugin_relates' );
   add_shortcode('Custom_Form_Builder','render');

?>
<script type="text/javascript" src="https://js.stripe.com/v2/"></script>